/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import javax.annotation.Nonnull;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.client.TextureCache;

public class CustomNpcResourceListener
implements IResourceManagerReloadListener {
    public static int DefaultTextColor = CustomNpcs.LableColor.getRGB();

    private void createTextureCache(IResourceManager resourceManager) {
        this.enlargeTexture("planks_oak", resourceManager);
        this.enlargeTexture("planks_big_oak", resourceManager);
        this.enlargeTexture("planks_birch", resourceManager);
        this.enlargeTexture("planks_jungle", resourceManager);
        this.enlargeTexture("planks_spruce", resourceManager);
        this.enlargeTexture("planks_acacia", resourceManager);
        this.enlargeTexture("iron_block", resourceManager);
        this.enlargeTexture("diamond_block", resourceManager);
        this.enlargeTexture("stone", resourceManager);
        this.enlargeTexture("gold_block", resourceManager);
        this.enlargeTexture("wool_colored_white", resourceManager);
    }

    private void enlargeTexture(String texture, IResourceManager resourceManager) {
        ResourceLocation location = new ResourceLocation("minecraft", "textures/cache/" + texture + ".png");
        IResource resource = null;
        try {
            resource = resourceManager.func_110536_a(location);
        }
        catch (Exception e) {
            LogWriter.debug("Not found texture: \"" + location + "\"");
        }
        if (!(resource instanceof TextureCache)) {
            new TextureCache(location).func_110551_a(resourceManager);
        } else {
            ((TextureCache)resource).setImage(new ResourceLocation("minecraft", "textures/blocks/" + texture + ".png"));
        }
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        if (resourceManager instanceof SimpleReloadableResourceManager) {
            this.createTextureCache(resourceManager);
            SimpleReloadableResourceManager simplemanager = (SimpleReloadableResourceManager)resourceManager;
            FolderResourcePack pack = new FolderResourcePack(CustomNpcs.Dir);
            simplemanager.func_110545_a((IResourcePack)pack);
            DefaultTextColor = CustomNpcs.LableColor.getRGB();
        }
    }
}

